/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.decorative_blocks.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.ForgeEventFactory;

public class BrazierBlock
extends Block
implements IWaterLoggable {
    protected static final VoxelShape BRAZIER_SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    protected static final VoxelShape BRAZIER_COLLISION_SHAPE = Block.func_208617_a((double)1.5, (double)0.0, (double)1.5, (double)14.5, (double)13.5, (double)14.5);
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private final boolean isSoul;

    public BrazierBlock(AbstractBlock.Properties properties, boolean isSoul) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)LIT, (Comparable)Boolean.TRUE)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
        this.isSoul = isSoul;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!entityIn.func_230279_az_() && ((Boolean)state.func_177229_b((Property)LIT)).booleanValue() && entityIn instanceof LivingEntity && !EnchantmentHelper.func_189869_j((LivingEntity)((LivingEntity)entityIn)) && entityIn.func_226278_cu_() >= state.func_196952_d((IBlockReader)worldIn, pos).func_197758_c(Direction.Axis.Y) + (double)pos.func_177956_o() - (double)0.1f) {
            entityIn.func_70097_a(DamageSource.field_76372_a, 1.0f);
        }
        super.func_196262_a(state, worldIn, pos, entityIn);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos;
        World iworld = context.func_195991_k();
        boolean flag = iworld.func_204610_c(blockpos = context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(!flag));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(handIn);
        if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
            if (heldItem.getToolTypes().contains(ToolType.SHOVEL)) {
                worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 0.8f, 1.0f);
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.FALSE));
                return ActionResultType.SUCCESS;
            }
        } else if (!((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue() && (hit.func_216354_b() == Direction.UP && heldItem.func_77973_b() == Items.field_151033_d || heldItem.func_77973_b() == Items.field_151059_bz)) {
            SoundEvent sound = heldItem.func_77973_b() == Items.field_151059_bz ? SoundEvents.field_187616_bj : SoundEvents.field_187649_bu;
            worldIn.func_184133_a((PlayerEntity)null, pos, sound, SoundCategory.BLOCKS, 1.0f, worldIn.field_73012_v.nextFloat() * 0.4f + 0.8f);
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.TRUE));
            return ActionResultType.CONSUME;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BRAZIER_SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BRAZIER_COLLISION_SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((Property)LIT)).booleanValue()) {
            if (rand.nextInt(10) == 0) {
                worldIn.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_219605_aC, SoundCategory.BLOCKS, 0.5f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.6f, false);
            }
            if (rand.nextInt(5) == 0) {
                for (int i = 0; i < rand.nextInt(1) + 1; ++i) {
                    if (this.isSoul) {
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_239812_C_, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.8f), (double)((float)pos.func_177952_p() + 0.5f), (double)((rand.nextFloat() - 0.5f) / 10.0f), (double)(rand.nextFloat() / 5.0f), ((double)rand.nextFloat() - 0.5) / 10.0);
                        continue;
                    }
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197595_F, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.8f), (double)((float)pos.func_177952_p() + 0.5f), (double)(rand.nextFloat() / 2.0f), 5.0E-5, (double)(rand.nextFloat() / 2.0f));
                }
            }
        }
    }

    public void func_220066_a(World worldIn, BlockState state, BlockRayTraceResult hit, ProjectileEntity projectile) {
        if (!worldIn.field_72995_K && projectile.func_70027_ad()) {
            boolean flag;
            Entity entity = projectile.func_234616_v_();
            boolean bl = flag = entity == null || entity instanceof PlayerEntity || ForgeEventFactory.getMobGriefingEvent((World)worldIn, (Entity)entity);
            if (flag && !((Boolean)state.func_177229_b((Property)LIT)).booleanValue() && !((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
                BlockPos blockpos = hit.func_216350_a();
                worldIn.func_180501_a(blockpos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.TRUE), 11);
            }
        }
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue() && fluidStateIn.func_206886_c() == Fluids.field_204546_a) {
            boolean flag = (Boolean)state.func_177229_b((Property)LIT);
            if (flag) {
                worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            worldIn.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.TRUE)).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
            worldIn.func_205219_F_().func_205360_a(pos, (Object)fluidStateIn.func_206886_c(), fluidStateIn.func_206886_c().func_205569_a((IWorldReader)worldIn));
            return true;
        }
        return false;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT, WATERLOGGED});
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return PathNodeType.DAMAGE_FIRE;
    }
}

